/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import noppes.npcs.CustomNpcs;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogWriter {
    private static void log(Level level, Object msg) {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[3];
        String methodName = caller.getMethodName() + "()";
        if (methodName.startsWith("lambda$") && (methodName = methodName.substring(methodName.indexOf("$") + 1)).contains("$")) {
            methodName = methodName.substring(0, methodName.indexOf("$"));
        }
        Logger logger = LogManager.getLogger((String)caller.getClassName());
        if (caller.getClassName().equals("noppes.npcs.util.DataDebug")) {
            logger.log(level, "{}", msg);
        } else {
            logger.log(level, "[Line #{}] {} \"{}\"", (Object)caller.getLineNumber(), (Object)methodName, msg);
        }
    }

    public static void debug(String msg) {
        if (!CustomNpcs.VerboseDebug || msg == null || msg.trim().isEmpty()) {
            return;
        }
        LogWriter.log(Level.INFO, msg);
    }

    public static void error(Object msg) {
        if (msg == null || msg.toString().isEmpty()) {
            return;
        }
        LogWriter.log(Level.ERROR, msg);
    }

    public static void error(Object msg, Throwable e) {
        if (msg != null && !msg.toString().isEmpty()) {
            LogWriter.log(Level.ERROR, msg.toString());
        }
        if (e != null) {
            LogWriter.log(Level.ERROR, e);
        }
    }

    public static void except(Throwable e) {
        if (e == null) {
            return;
        }
        LogWriter.log(Level.FATAL, e);
    }

    public static void info(Object msg) {
        if (msg == null || msg.toString().isEmpty()) {
            return;
        }
        LogWriter.log(Level.INFO, msg);
    }

    public static void warn(Object msg) {
        if (msg == null || msg.toString().isEmpty()) {
            return;
        }
        LogWriter.log(Level.WARN, msg);
    }
}

